/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity.experimental;

import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import java.util.LinkedList;

public class Sift4
implements StringDistance {
    private static final int DEFAULT_MAX_OFFSET = 10;
    private int max_offset = 10;

    public final void setMaxOffset(int max_offset) {
        this.max_offset = max_offset;
    }

    public final double distance(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            if (s2 == null) {
                return 0.0;
            }
            return s2.length();
        }
        if (s2 == null || s2.isEmpty()) {
            return s1.length();
        }
        int l1 = s1.length();
        int l2 = s2.length();
        int c1 = 0;
        int c2 = 0;
        int lcss = 0;
        int local_cs = 0;
        int trans = 0;
        class Offset {
            private final int c1;
            private final int c2;
            private boolean trans;

            Offset(int c1, int c2, boolean trans) {
                this.c1 = c1;
                this.c2 = c2;
                this.trans = trans;
            }
        }
        LinkedList<Offset> offset_arr = new LinkedList<Offset>();
        while (c1 < l1 && c2 < l2) {
            if (s1.charAt(c1) == s2.charAt(c2)) {
                ++local_cs;
                boolean is_trans = false;
                int i = 0;
                while (i < offset_arr.size()) {
                    Offset ofs = (Offset)offset_arr.get(i);
                    if (c1 <= ofs.c1 || c2 <= ofs.c2) {
                        boolean bl = is_trans = Math.abs(c2 - c1) >= Math.abs(ofs.c2 - ofs.c1);
                        if (is_trans) {
                            ++trans;
                            break;
                        }
                        if (ofs.trans) break;
                        ofs.trans = true;
                        ++trans;
                        break;
                    }
                    if (c1 > ofs.c2 && c2 > ofs.c1) {
                        offset_arr.remove(i);
                        continue;
                    }
                    ++i;
                }
                offset_arr.add(new Offset(c1, c2, is_trans));
            } else {
                lcss += local_cs;
                local_cs = 0;
                if (c1 != c2) {
                    c2 = c1 = Math.min(c1, c2);
                }
                for (int i = 0; i < this.max_offset && (c1 + i < l1 || c2 + i < l2); ++i) {
                    if (c1 + i < l1 && s1.charAt(c1 + i) == s2.charAt(c2)) {
                        c1 += i - 1;
                        --c2;
                        break;
                    }
                    if (c2 + i >= l2 || s1.charAt(c1) != s2.charAt(c2 + i)) continue;
                    --c1;
                    c2 += i - 1;
                    break;
                }
            }
            if (++c1 < l1 && ++c2 < l2) continue;
            lcss += local_cs;
            local_cs = 0;
            c2 = c1 = Math.min(c1, c2);
        }
        return Math.round(Math.max(l1, l2) - (lcss += local_cs) + trans);
    }
}

