/*
 * Decompiled with CFR 0.152.
 */
package parser;

import diff.DiffingLines;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Commit {
    public RevCommit commit;
    public Map<String, DiffingLines.DiffLines> diffWithParent;
    public Map<String, DiffEntry.ChangeType> changeTypes;
    public Map<String, Collection<RevCommit>> fileAnnotations;

    public Commit(RevCommit commit) {
        this.commit = commit;
        this.diffWithParent = new HashMap<String, DiffingLines.DiffLines>();
        this.changeTypes = new HashMap<String, DiffEntry.ChangeType>();
    }

    public String getHashString() {
        return ObjectId.toString(this.commit.toObjectId());
    }

    public String toString() {
        String path;
        StringBuilder sb = new StringBuilder();
        if (this.diffWithParent != null) {
            for (Map.Entry<String, DiffingLines.DiffLines> entry : this.diffWithParent.entrySet()) {
                path = entry.getKey();
                sb.append(path);
                sb.append("  " + (Object)((Object)this.changeTypes.get(path)));
                sb.append("\n");
                sb.append(entry.getValue().getJSON());
                sb.append("\n");
            }
        }
        if (this.fileAnnotations != null) {
            sb.append("Annotation graph\n");
            for (Map.Entry<String, Object> entry : this.fileAnnotations.entrySet()) {
                path = entry.getKey();
                sb.append(path);
                sb.append("\n");
                sb.append("[");
                for (RevCommit c : (Collection)entry.getValue()) {
                    sb.append(c + "->");
                }
                sb.append("]\n");
            }
        }
        return this.commit.toString() + "\n\n" + sb.toString();
    }

    public JSONObject toJson() {
        JSONObject tree = new JSONObject();
        JSONObject diffing = new JSONObject();
        for (Map.Entry<String, DiffingLines.DiffLines> diff : this.diffWithParent.entrySet()) {
            String file = diff.getKey();
            JSONArray lines = new JSONArray();
            DiffingLines.DiffLines line = diff.getValue();
            lines.add(line.getJSON());
            diffing.put(file, lines);
        }
        tree.put("diff", diffing);
        JSONObject changes = new JSONObject();
        for (Map.Entry<String, DiffEntry.ChangeType> changeType : this.changeTypes.entrySet()) {
            changes.put(changeType.getKey(), changeType.getValue().toString());
        }
        tree.put("changes", changes);
        return tree;
    }
}

