/*
 * Decompiled with CFR 0.152.
 */
package diff;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DiffingLines {
    private int customContext;
    private Repository repo = null;

    public DiffingLines(Repository repo, int customContext) {
        this.repo = repo;
        if (customContext < 0) {
            throw new IllegalStateException("Custom Context can't be lower than 0!!");
        }
        this.customContext = customContext;
    }

    private RawText toRaw(AbbreviatedObjectId id) {
        try {
            ObjectLoader loader = this.repo.open(id.toObjectId());
            return RawText.load(loader, 0x3200000);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DiffLines getDiffingLines(DiffEntry entry, EditList edits) throws IOException, GitAPIException {
        RawText old = this.toRaw(entry.getOldId());
        RawText present = this.toRaw(entry.getNewId());
        if (old == null || present == null) {
            return new DiffLines();
        }
        DiffLines lines = new DiffLines();
        int i = 0;
        while (i < edits.size()) {
            Edit first = (Edit)edits.get(i);
            int last = this.last(edits, i);
            Edit second = (Edit)edits.get(last);
            int firstIndex = first.getBeginA() - this.customContext;
            int firstEnd = second.getEndA() + this.customContext;
            int secondIndex = first.getBeginB() - this.customContext;
            int secondEnd = second.getEndB() + this.customContext;
            firstIndex = 0 > firstIndex ? 0 : firstIndex;
            firstEnd = old.size() < firstEnd ? old.size() : firstEnd;
            secondIndex = 0 > secondIndex ? 0 : secondIndex;
            int n = secondEnd = present.size() < secondEnd ? present.size() : secondEnd;
            while (firstIndex < firstEnd || secondIndex < secondEnd) {
                String[] info = null;
                if (firstIndex < first.getBeginA() || last + 1 < i) {
                    info = new String[]{Integer.toString(firstIndex), old.getString(firstIndex)};
                    lines.insertions.add(info);
                    ++firstIndex;
                    ++secondIndex;
                } else if (firstIndex < first.getEndA()) {
                    info = new String[]{Integer.toString(firstIndex), old.getString(firstIndex)};
                    lines.deletions.add(info);
                    ++firstIndex;
                } else if (secondIndex < first.getEndB()) {
                    info = new String[]{Integer.toString(secondIndex), present.getString(secondIndex)};
                    lines.insertions.add(info);
                    ++secondIndex;
                }
                if (firstIndex < first.getEndA() || secondIndex < first.getEndB() || ++i >= edits.size()) continue;
                first = (Edit)edits.get(i);
            }
        }
        return lines;
    }

    private int last(List<Edit> edits, int i) {
        Edit first = null;
        Edit second = null;
        int last = i + 1;
        while (last < edits.size()) {
            first = edits.get(last);
            second = edits.get(last - 1);
            if (first.getBeginA() - second.getEndA() > 2 * this.customContext || first.getBeginB() - second.getEndB() > 2 * this.customContext) {
                return last - 1;
            }
            ++last;
        }
        return last - 1;
    }

    public class DiffLines {
        public List<String[]> insertions = new LinkedList<String[]>();
        public List<String[]> deletions = new LinkedList<String[]>();

        public JSONObject getJSON() {
            JSONObject diffLines = new JSONObject();
            JSONArray added = new JSONArray();
            JSONArray deleted = new JSONArray();
            for (String[] lineNNumber : this.insertions) {
                added.add(lineNNumber[0]);
                added.add(lineNNumber[1]);
            }
            for (String[] lineNNumber : this.deletions) {
                deleted.add(lineNNumber[0]);
                deleted.add(lineNNumber[1]);
            }
            diffLines.put("add", added);
            diffLines.put("delete", deleted);
            return diffLines;
        }

        public String toString() {
            return "";
        }
    }
}

