/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.FileAnnotationGraph;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class AnnotationMap<K, V>
extends HashMap<K, V> {
    public void saveToJSON(String path) {
        Set entries = this.entrySet();
        JSONObject tree = new JSONObject();
        for (Map.Entry entry : entries) {
            String commit = (String)entry.getKey();
            JSONArray jFileObject = new JSONArray();
            List graphs = (List)entry.getValue();
            for (FileAnnotationGraph graph : graphs) {
                jFileObject.add(graph.getGraphJSON());
            }
            tree.put(commit, jFileObject);
        }
        if (path != null) {
            try (FileWriter file = new FileWriter(path + "/annotations.json");){
                file.write(tree.toJSONString());
                file.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Can't save AnnotationMap to a null path...");
        }
    }
}

