/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import data.Issues;
import diff.DiffingLines;
import graph.AnnotationMap;
import graph.FileAnnotationGraph;
import heuristics.BugIntroducerFinder;
import info.debatty.java.stringsimilarity.Jaccard;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import parser.Commit;
import util.CommitUtil;

public class DistanceIntroducerFinder
implements BugIntroducerFinder {
    private Repository repo;
    private Issues issues;
    private CommitUtil util;

    public DistanceIntroducerFinder(Repository repo, int customContext) {
        this.util = new CommitUtil(repo, customContext);
    }

    private int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private RevCommit stringToRev(String rev) {
        RevCommit commit = null;
        try {
            commit = this.repo.parseCommit(this.repo.resolve(rev));
        }
        catch (Exception e) {
            return null;
        }
        return commit;
    }

    private RevisionDistance compareTwoSections(List<String[]> current, List<String> other, Map<Integer, Integer> lineMapping) {
        RevisionDistance dist = new RevisionDistance();
        dist.updatedDiffLines = new LinkedList<String[]>();
        Iterator<String[]> currentIterator = current.iterator();
        double distance = 0.0;
        Jaccard j2 = new Jaccard(2);
        while (currentIterator.hasNext()) {
            String[] entry = currentIterator.next();
            int lineId = this.parseInt(entry[0]);
            if (lineId < 0) continue;
            int otherId = -1;
            try {
                otherId = lineMapping.get(lineId);
                if (entry[1] == null) continue;
                distance += j2.distance(entry[1], other.get(otherId));
                dist.updatedDiffLines.add(new String[]{Integer.toString(otherId), entry[1]});
            }
            catch (Exception exception) {}
        }
        dist.distance = current.size() > 0 ? distance / (double)current.size() : distance;
        return dist;
    }

    @Override
    public List<String[]> findBugIntroducingCommits(AnnotationMap<String, List<FileAnnotationGraph>> graphs) throws IOException, GitAPIException {
        LinkedList<String[]> bugIntroducers = new LinkedList<String[]>();
        for (Map.Entry entry : graphs.entrySet()) {
            List files = new LinkedList();
            RevCommit sCommit = null;
            sCommit = this.stringToRev((String)entry.getKey());
            if (sCommit == null) continue;
            files = (List)entry.getValue();
            Commit source = this.util.getCommitDiffingLines(sCommit, new RevCommit[0]);
            for (FileAnnotationGraph graph : files) {
                String[] fixBugPair = new String[2];
                fixBugPair[0] = (String)entry.getKey();
                DiffingLines.DiffLines diffLines = source.diffWithParent.get(graph.filePath);
                List<String[]> deletions = diffLines.deletions;
                Iterator revisions = graph.revisions.iterator();
                revisions.next();
                if (!revisions.hasNext()) continue;
                String prevRevision = (String)revisions.next();
                double smallest = 1.0;
                String smallestDistCommit = prevRevision;
                while (revisions.hasNext()) {
                    String revision = (String)revisions.next();
                    RevCommit next = null;
                    next = this.stringToRev(revision);
                    if (next == null) continue;
                    List<String> nextLines = this.util.getFileLines(next.getTree(), graph.filePath);
                    Map<Integer, Integer> lineMapping = graph.getLineMapping(revision);
                    RevisionDistance distance = this.compareTwoSections(deletions, nextLines, lineMapping);
                    if (distance.distance < smallest) {
                        smallest = distance.distance;
                        smallestDistCommit = revision;
                    }
                    deletions = distance.updatedDiffLines;
                }
                fixBugPair[1] = smallestDistCommit;
                bugIntroducers.add(fixBugPair);
            }
        }
        return bugIntroducers;
    }

    private class RevisionDistance {
        public double distance;
        public List<String[]> updatedDiffLines;

        private RevisionDistance() {
        }
    }
}

