/*
 * Decompiled with CFR 0.152.
 */
package util;

import data.Issues;
import diff.DiffingLines;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import parser.Commit;

public class CommitUtil {
    private Git git;
    private Issues issues;
    private Repository repo;
    private int customContext;

    public CommitUtil(Repository repo, int customContext) {
        this.repo = repo;
        this.git = new Git(repo);
        this.customContext = customContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getFileLines(RevTree tree, String path) throws IOException, GitAPIException {
        try (TreeWalk walk = new TreeWalk(this.repo);){
            walk.addTree(tree);
            walk.setRecursive(true);
            walk.setFilter(PathFilter.create(path));
            walk.next();
            ObjectId oId = walk.getObjectId(0);
            if (oId == ObjectId.zeroId()) {
                LinkedList<String> linkedList = new LinkedList<String>();
                return linkedList;
            }
            ObjectLoader loader = this.repo.open(oId);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            loader.copyTo(stream);
            List<String> list = IOUtils.readLines((InputStream)new ByteArrayInputStream(stream.toByteArray()), "UTF-8");
            return list;
        }
        catch (Exception e) {
            return new LinkedList<String>();
        }
    }

    public List<Commit> getDiffingLines(Set<RevCommit> commits) throws IOException, GitAPIException {
        LinkedList<Commit> parsedCommits = new LinkedList<Commit>();
        for (RevCommit revc : commits) {
            Commit commit = this.getCommitDiffingLines(revc, new RevCommit[0]);
            if (commit == null || commit.diffWithParent.isEmpty()) continue;
            parsedCommits.add(commit);
        }
        return parsedCommits;
    }

    public List<DiffEntry> diffRevisions(RevCommit a, RevCommit b) throws IOException, GitAPIException {
        return this.git.diff().setOldTree(this.getCanonicalTreeParser(a)).setNewTree(this.getCanonicalTreeParser(b)).call();
    }

    public EditList getDiffEditList(DiffEntry entry) throws IOException, GitAPIException {
        DiffFormatter form = new DiffFormatter(DisabledOutputStream.INSTANCE);
        form.setRepository(this.git.getRepository());
        FileHeader fh = form.toFileHeader(entry);
        return fh.toEditList();
    }

    public DiffingLines.DiffLines diffFile(DiffEntry entry) throws IOException, GitAPIException {
        EditList edits = this.getDiffEditList(entry);
        DiffingLines differ = new DiffingLines(this.repo, this.customContext);
        return differ.getDiffingLines(entry, edits);
    }

    public Commit getCommitDiffingLines(RevCommit revc, RevCommit ... revother) throws IOException, GitAPIException {
        if (revc.getId() == revc.zeroId()) {
            return null;
        }
        RevCommit parent = null;
        parent = revother.length > 0 ? revother[0] : (revc.getParents().length > 0 ? revc.getParent(0) : revc);
        if (parent.getId() == ObjectId.zeroId()) {
            return null;
        }
        List<DiffEntry> diffEntries = this.diffRevisions(parent, revc);
        Commit commit = new Commit(revc);
        for (DiffEntry entry : diffEntries) {
            DiffingLines.DiffLines changedLines = this.diffFile(entry);
            commit.diffWithParent.put(entry.getNewPath(), changedLines);
            commit.changeTypes.put(entry.getNewPath(), entry.getChangeType());
        }
        return commit;
    }

    /*
     * Exception decompiling
     */
    private AbstractTreeIterator getCanonicalTreeParser(ObjectId commitId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

