/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FileAnnotationGraph {
    public String filePath;
    public LinkedList<String> revisions;
    public Map<String, Map<Integer, Integer>> mappings;
    public Map<String, FileAnnotationGraph> sub_graphs;

    public Map<Integer, Integer> getLineMapping(String revision) {
        if (revision == this.revisions.getFirst()) {
            System.err.println("Revision must have a successor! Return empty map..");
            return new LinkedHashMap<Integer, Integer>();
        }
        return this.mappings.get(revision);
    }

    public LinkedList<String> getRevisions() {
        return this.revisions;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public JSONObject getGraphJSON() {
        JSONObject tree = new JSONObject();
        tree.put("filePath", this.filePath);
        JSONArray revisionArray = new JSONArray();
        for (String rev : this.revisions) {
            revisionArray.add(rev);
        }
        tree.put("revisions", revisionArray);
        JSONObject jsonLineMappings = new JSONObject();
        Map<Integer, Integer> lineMappings = null;
        JSONObject lineMappingsObject = null;
        for (String rev : this.mappings.keySet()) {
            lineMappings = this.mappings.get(rev);
            lineMappingsObject = new JSONObject();
            for (Map.Entry<Integer, Integer> lineMapping : lineMappings.entrySet()) {
                lineMappingsObject.put(lineMapping.getKey(), lineMapping.getValue());
            }
            jsonLineMappings.put(rev, lineMappingsObject);
        }
        tree.put("mappings", jsonLineMappings);
        JSONObject subGraphs = new JSONObject();
        for (Map.Entry<String, FileAnnotationGraph> entry : this.sub_graphs.entrySet()) {
            subGraphs.put(entry.getKey(), entry.getValue().getGraphJSON());
        }
        tree.put("subgraphs", subGraphs);
        return tree;
    }
}

