/*
 * Decompiled with CFR 0.152.
 */
package parser;

import graph.AnnotationMap;
import graph.FileAnnotationGraph;
import heuristics.BugFinderFactory;
import heuristics.BugIntroducerFinder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parser.GitParser;
import util.Configuration;
import util.JSONUtil;

public class GitParserThread
extends Thread {
    public GitParser parser;
    private String issues;
    private int bugFinder;
    private int depth;
    private Logger logger = LoggerFactory.getLogger(GitParserThread.class);

    public GitParserThread(String repo, String issues, String results, int bugFinder, int depth, int customContext) {
        try {
            this.parser = new GitParser(repo, results, depth, customContext);
            this.issues = issues;
            this.bugFinder = bugFinder;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        this.depth = depth;
    }

    public GitParserThread(int id, String issues) {
        Configuration conf = Configuration.getInstance();
        try {
            this.parser = new GitParser(conf.getRepository(), String.format("%s/result%d", conf.getResultPath(), id), conf.getDepth(), conf.getDiffCustomContext());
            this.issues = issues;
            this.bugFinder = conf.getBugFinder();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.parser.useLogger(this.logger);
        this.logger.info("Started process...");
        try {
            Set<RevCommit> commits = this.parser.readBugFixCommits(this.issues);
            this.logger.info("Checking each commits diff...");
            AnnotationMap<String, List<FileAnnotationGraph>> graphs = this.parser.annotateCommits(commits);
            this.logger.info("Trying to find potential bug introducing commits...");
            List<String[]> bugIntroducers = Collections.emptyList();
            BugIntroducerFinder finder = BugFinderFactory.getFinder(this.parser.getRepository(), this.parser.getIssues());
            bugIntroducers = finder.findBugIntroducingCommits(graphs);
            this.logger.info("Saving found bug introducing commits...");
            JSONUtil.saveBugIntroducingCommits(bugIntroducers, this.parser.getResultPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
    }
}

