/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.annotations;

import java.util.ArrayList;
import java.util.List;

public enum Mode {
    Throughput("thrpt", "Throughput, ops/time"),
    AverageTime("avgt", "Average time, time/op"),
    SampleTime("sample", "Sampling time"),
    SingleShotTime("ss", "Single shot invocation time"),
    All("all", "All benchmark modes");

    private final String shortLabel;
    private final String longLabel;

    private Mode(String shortLabel, String longLabel) {
        this.shortLabel = shortLabel;
        this.longLabel = longLabel;
    }

    public String shortLabel() {
        return this.shortLabel;
    }

    public String longLabel() {
        return this.longLabel;
    }

    public static Mode deepValueOf(String name) {
        try {
            return Mode.valueOf(name);
        }
        catch (IllegalArgumentException iae) {
            Mode inferred = null;
            for (Mode type : Mode.values()) {
                if (!type.shortLabel().startsWith(name)) continue;
                if (inferred == null) {
                    inferred = type;
                    continue;
                }
                throw new IllegalStateException("Unable to parse benchmark mode, ambiguous prefix given: \"" + name + "\"\n" + "Known values are " + Mode.getKnown());
            }
            if (inferred != null) {
                return inferred;
            }
            throw new IllegalStateException("Unable to parse benchmark mode: \"" + name + "\"\n" + "Known values are " + Mode.getKnown());
        }
    }

    public static List<String> getKnown() {
        ArrayList<String> res = new ArrayList<String>();
        for (Mode type : Mode.values()) {
            res.add(type.name() + "/" + type.shortLabel());
        }
        return res;
    }
}

