/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Timeout;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GenerationException;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.MethodInvocation;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Optional;

class MethodGroup
implements Comparable<MethodGroup> {
    private final ClassInfo ci;
    private final String name;
    private final Set<MethodInvocation> methods;
    private final EnumSet<Mode> modes;
    private final Map<String, String[]> params;
    private boolean strictFP;

    public MethodGroup(ClassInfo ci, String name) {
        this.ci = ci;
        this.name = name;
        this.methods = new TreeSet<MethodInvocation>();
        this.modes = EnumSet.noneOf(Mode.class);
        this.params = new TreeMap<String, String[]>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodGroup methodGroup = (MethodGroup)o;
        return this.name.equals(methodGroup.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(MethodGroup o) {
        return this.name.compareTo(o.name);
    }

    public void addMethod(MethodInfo method, int threads) {
        this.methods.add(new MethodInvocation(method, threads));
    }

    public Collection<MethodInfo> methods() {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInvocation m : this.methods) {
            result.add(m.method);
        }
        return result;
    }

    public Optional<Integer> getTotalThreadCount() {
        Threads ann = this.getFinal(Threads.class);
        if (ann != null) {
            return Optional.of(ann.value());
        }
        return Optional.none();
    }

    public String getName() {
        return this.name;
    }

    public void addParamValues(String name, String[] value) {
        this.params.put(name, value);
    }

    public void addStrictFP(boolean sfp) {
        this.strictFP |= sfp;
    }

    public boolean isStrictFP() {
        return this.strictFP;
    }

    public void addModes(Mode eMode) {
        this.modes.add(eMode);
    }

    public void addModes(Mode[] eModes) {
        Collections.addAll(this.modes, eModes);
    }

    public Set<Mode> getModes() {
        return this.modes;
    }

    public int[] getThreads() {
        int[] threads = new int[this.methods.size()];
        int c = 0;
        for (MethodInvocation mi : this.methods) {
            threads[c++] = mi.threads;
        }
        return threads;
    }

    public Optional<Integer> getOperationsPerInvocation() {
        OperationsPerInvocation ann = this.getFinal(OperationsPerInvocation.class);
        return ann != null ? Optional.of(ann.value()) : Optional.none();
    }

    public Optional<TimeUnit> getOutputTimeUnit() {
        OutputTimeUnit ann = this.getFinal(OutputTimeUnit.class);
        return ann != null ? Optional.of(ann.value()) : Optional.none();
    }

    public Optional<Integer> getWarmupIterations() {
        Warmup ann = this.getFinal(Warmup.class);
        if (ann != null && ann.iterations() != -1) {
            return Optional.of(ann.iterations());
        }
        return Optional.none();
    }

    public Optional<TimeValue> getWarmupTime() {
        Warmup ann = this.getFinal(Warmup.class);
        if (ann != null && ann.time() != -1) {
            return Optional.of(new TimeValue(ann.time(), ann.timeUnit()));
        }
        return Optional.none();
    }

    public Optional<Integer> getWarmupBatchSize() {
        Warmup ann = this.getFinal(Warmup.class);
        if (ann != null && ann.batchSize() != -1) {
            return Optional.of(ann.batchSize());
        }
        return Optional.none();
    }

    public Optional<Integer> getMeasurementIterations() {
        Measurement ann = this.getFinal(Measurement.class);
        if (ann != null && ann.iterations() != -1) {
            return Optional.of(ann.iterations());
        }
        return Optional.none();
    }

    public Optional<TimeValue> getMeasurementTime() {
        Measurement ann = this.getFinal(Measurement.class);
        if (ann != null && ann.time() != -1) {
            return Optional.of(new TimeValue(ann.time(), ann.timeUnit()));
        }
        return Optional.none();
    }

    public Optional<Integer> getMeasurementBatchSize() {
        Measurement ann = this.getFinal(Measurement.class);
        if (ann != null && ann.batchSize() != -1) {
            return Optional.of(ann.batchSize());
        }
        return Optional.none();
    }

    public Optional<Integer> getForks() {
        Fork ann = this.getFinal(Fork.class);
        if (ann != null && ann.value() != -1) {
            return Optional.of(ann.value());
        }
        return Optional.none();
    }

    public Optional<Integer> getWarmupForks() {
        Fork ann = this.getFinal(Fork.class);
        if (ann != null && ann.warmups() != -1) {
            return Optional.of(ann.warmups());
        }
        return Optional.none();
    }

    public Optional<String> getJvm() {
        Fork ann = this.getFinal(Fork.class);
        if (ann != null && !ann.jvm().equals("blank_blank_blank_2014")) {
            return Optional.of(ann.jvm());
        }
        return Optional.none();
    }

    public Optional<Collection<String>> getJvmArgs() {
        Fork ann = this.getFinal(Fork.class);
        if (!(ann == null || ann.jvmArgs().length == 1 && ann.jvmArgs()[0].equals("blank_blank_blank_2014"))) {
            return Optional.of(Arrays.asList(ann.jvmArgs()));
        }
        return Optional.none();
    }

    public Optional<Collection<String>> getJvmArgsAppend() {
        Fork ann = this.getFinal(Fork.class);
        if (!(ann == null || ann.jvmArgsAppend().length == 1 && ann.jvmArgsAppend()[0].equals("blank_blank_blank_2014"))) {
            return Optional.of(Arrays.asList(ann.jvmArgsAppend()));
        }
        return Optional.none();
    }

    public Optional<Collection<String>> getJvmArgsPrepend() {
        Fork ann = this.getFinal(Fork.class);
        if (!(ann == null || ann.jvmArgsPrepend().length == 1 && ann.jvmArgsPrepend()[0].equals("blank_blank_blank_2014"))) {
            return Optional.of(Arrays.asList(ann.jvmArgsPrepend()));
        }
        return Optional.none();
    }

    public Optional<TimeValue> getTimeout() {
        Timeout ann = this.getFinal(Timeout.class);
        if (ann != null) {
            return Optional.of(new TimeValue(ann.time(), ann.timeUnit()));
        }
        return Optional.none();
    }

    private <T extends Annotation> T getFinal(Class<T> annClass) {
        Annotation finalAnn = null;
        for (MethodInvocation mi : this.methods) {
            T ann = BenchmarkGeneratorUtils.getAnnSuper(mi.method, this.ci, annClass);
            if (ann == null) continue;
            if (finalAnn != null && !finalAnn.equals(ann)) {
                throw new GenerationException("Colliding annotations: " + ann + " vs. " + finalAnn, mi.method);
            }
            finalAnn = (Annotation)ann;
        }
        return (T)finalAnn;
    }

    public Optional<Map<String, String[]>> getParams() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        for (Map.Entry<String, String[]> e : this.params.entrySet()) {
            String key = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1 && values[0].equalsIgnoreCase("blank_blank_blank_2014")) {
                map.put(key, new String[0]);
                continue;
            }
            map.put(key, values);
        }
        if (this.params.isEmpty()) {
            return Optional.none();
        }
        return Optional.of(map);
    }
}

