/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;

public class ClassloaderProfiler
implements InternalProfiler {
    private long loadedClasses = -1L;
    private long unloadedClasses = -1L;

    @Override
    public String getDescription() {
        return "Classloader profiling via standard MBeans";
    }

    @Override
    public boolean checkSupport(List<String> msgs) {
        return true;
    }

    @Override
    public String label() {
        return "cl";
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        try {
            this.loadedClasses = cl.getLoadedClassCount();
        }
        catch (UnsupportedOperationException e) {
            this.loadedClasses = -1L;
        }
        try {
            this.unloadedClasses = cl.getUnloadedClassCount();
        }
        catch (UnsupportedOperationException e) {
            this.unloadedClasses = -1L;
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        long unloaded;
        long unloadedClassCount;
        long loaded;
        int loadedClassCount;
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        try {
            loadedClassCount = cl.getLoadedClassCount();
            loaded = (long)loadedClassCount - this.loadedClasses;
        }
        catch (UnsupportedOperationException e) {
            loaded = -1L;
            loadedClassCount = -1;
        }
        try {
            unloadedClassCount = cl.getUnloadedClassCount();
            unloaded = unloadedClassCount - this.unloadedClasses;
        }
        catch (UnsupportedOperationException e) {
            unloaded = -1L;
            unloadedClassCount = -1L;
        }
        return Arrays.asList(new ProfilerResult("@classload.loaded.profiled", loaded, "classes", AggregationPolicy.SUM), new ProfilerResult("@classload.unloaded.profiled", unloaded, "classes", AggregationPolicy.SUM), new ProfilerResult("@classload.loaded.total", loadedClassCount, "classes", AggregationPolicy.MAX), new ProfilerResult("@classload.unloaded.total", unloadedClassCount, "classes", AggregationPolicy.MAX));
    }
}

