/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.JSONResultFormat;
import org.openjdk.jmh.results.format.LaTeXResultFormat;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.results.format.TextResultFormat;
import org.openjdk.jmh.results.format.XSVResultFormat;

public class ResultFormatFactory {
    private ResultFormatFactory() {
    }

    public static ResultFormat getInstance(final ResultFormatType type, final String file) {
        return new ResultFormat(){

            @Override
            public void writeOut(Collection<RunResult> results) {
                try {
                    PrintStream pw = new PrintStream(file);
                    ResultFormat rf = ResultFormatFactory.getInstance(type, pw);
                    rf.writeOut(results);
                    pw.flush();
                    pw.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public static ResultFormat getInstance(ResultFormatType type, PrintStream out) {
        switch (type) {
            case TEXT: {
                return new TextResultFormat(out);
            }
            case CSV: {
                return new XSVResultFormat(out, ",");
            }
            case SCSV: {
                return new XSVResultFormat(out, ";");
            }
            case JSON: {
                return new JSONResultFormat(out);
            }
            case LATEX: {
                return new LaTeXResultFormat(out);
            }
        }
        throw new IllegalStateException("Unsupported result format: " + (Object)((Object)type));
    }
}

