/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.Profiler;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.BenchmarkHandler;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.WorkerThreadFactory;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.Utils;

abstract class BaseBenchmarkHandler
implements BenchmarkHandler {
    protected final ExecutorService executor;
    protected final ThreadLocal<Object> instances;
    protected final OutputFormat out;
    private final List<InternalProfiler> registeredProfilers;
    private static final ExecutorType EXECUTOR_TYPE = Enum.valueOf(ExecutorType.class, System.getProperty("jmh.executor", ExecutorType.FIXED_TPE.name()));

    public BaseBenchmarkHandler(OutputFormat out, final Class<?> clazz, Options options, BenchmarkParams executionParams) {
        this.registeredProfilers = BaseBenchmarkHandler.createProfilers(options);
        this.instances = new ThreadLocal<Object>(){

            @Override
            protected Object initialValue() {
                try {
                    return clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Class " + clazz.getName() + " instantiation error ", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Class " + clazz.getName() + " instantiation error ", e);
                }
            }
        };
        this.out = out;
        try {
            this.executor = EXECUTOR_TYPE.createExecutor(executionParams.getThreads(), executionParams.getBenchmark());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static List<InternalProfiler> createProfilers(Options options) {
        ArrayList<InternalProfiler> list = new ArrayList<InternalProfiler>();
        for (Class<? extends Profiler> prof : options.getProfilers()) {
            if (!ProfilerFactory.isInternal(prof)) continue;
            list.add((InternalProfiler)ProfilerFactory.prepareProfiler(prof, options.verbosity().orElse(Defaults.VERBOSITY)));
        }
        return list;
    }

    static ThreadParams[] distributeThreads(int threads, int[] groups) {
        ThreadParams[] result = new ThreadParams[threads];
        int totalGroupThreads = Utils.sum(groups);
        int totalGroups = (int)Math.ceil(1.0 * (double)threads / (double)totalGroupThreads);
        int totalSubgroups = groups.length;
        int currentGroupThread = 0;
        int currentSubgroupThread = 0;
        int currentGroup = 0;
        int currentSubgroup = 0;
        for (int t = 0; t < threads; ++t) {
            while (currentSubgroupThread >= groups[currentSubgroup]) {
                if (++currentSubgroup == groups.length) {
                    ++currentGroup;
                    currentSubgroup = 0;
                    currentGroupThread = 0;
                }
                currentSubgroupThread = 0;
            }
            result[t] = new ThreadParams(t, threads, currentGroup, totalGroups, currentSubgroup, totalSubgroups, currentGroupThread, totalGroupThreads, currentSubgroupThread, groups[currentSubgroup]);
            ++currentGroupThread;
            ++currentSubgroupThread;
        }
        return result;
    }

    protected void stopProfilers(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iterationResults) {
        for (InternalProfiler prof : this.registeredProfilers) {
            try {
                iterationResults.addResults(prof.afterIteration(benchmarkParams, iterationParams));
            }
            catch (Throwable ex) {
                throw new BenchmarkException(ex);
            }
        }
    }

    protected void startProfilers(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        for (InternalProfiler prof : this.registeredProfilers) {
            try {
                prof.beforeIteration(benchmarkParams, iterationParams);
            }
            catch (Throwable ex) {
                throw new BenchmarkException(ex);
            }
        }
    }

    @Override
    public void shutdown() {
        if (EXECUTOR_TYPE.shutdownForbidden() || this.executor == null) {
            return;
        }
        while (true) {
            this.executor.shutdown();
            try {
                if (this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.out.println("Failed to stop executor service " + this.executor + ", trying again; check for the unaccounted running threads");
        }
    }

    private static enum ExecutorType {
        CACHED_TPE{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) {
                return Executors.newCachedThreadPool(new WorkerThreadFactory(prefix));
            }
        }
        ,
        FIXED_TPE{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) {
                return Executors.newFixedThreadPool(maxThreads, new WorkerThreadFactory(prefix));
            }
        }
        ,
        FJP{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                Constructor<?> c = Class.forName("java.util.concurrent.ForkJoinPool").getConstructor(Integer.TYPE);
                return (ExecutorService)c.newInstance(maxThreads);
            }
        }
        ,
        FJP_COMMON{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                Method m = Class.forName("java.util.concurrent.ForkJoinPool").getMethod("commonPool", new Class[0]);
                return (ExecutorService)m.invoke(null, new Object[0]);
            }

            @Override
            boolean shutdownForbidden() {
                return true;
            }
        }
        ,
        CUSTOM{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                String className = System.getProperty("jmh.executor.class");
                return (ExecutorService)Class.forName(className).getConstructor(Integer.TYPE, String.class).newInstance(maxThreads, prefix);
            }
        };


        abstract ExecutorService createExecutor(int var1, String var2) throws Exception;

        boolean shutdownForbidden() {
            return false;
        }
    }
}

