/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.runner.Action;
import org.openjdk.jmh.runner.ActionMode;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.BenchmarkHandler;
import org.openjdk.jmh.runner.BenchmarkHandlers;
import org.openjdk.jmh.runner.IterationResultAcceptor;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.ClassUtils;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.TreeMultimap;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.util.Version;

abstract class BaseRunner {
    private long projectedTotalTime;
    private long projectedRunningTime;
    private long actualRunningTime;
    private long benchmarkStart;
    protected final Options options;
    protected final OutputFormat out;

    public BaseRunner(Options options, OutputFormat handler) {
        if (options == null) {
            throw new IllegalArgumentException("Options is null.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler is null.");
        }
        this.options = options;
        this.out = handler;
    }

    protected void runBenchmarksForked(ActionPlan actionPlan, IterationResultAcceptor acceptor) {
        for (Action action : actionPlan.getActions()) {
            BenchmarkParams params = action.getParams();
            ActionMode mode = action.getMode();
            this.doSingle(params, mode, acceptor);
        }
    }

    protected Multimap<BenchmarkParams, BenchmarkResult> runBenchmarksEmbedded(ActionPlan actionPlan) {
        TreeMultimap<BenchmarkParams, BenchmarkResult> results = new TreeMultimap<BenchmarkParams, BenchmarkResult>();
        for (Action action : actionPlan.getActions()) {
            BenchmarkParams params = action.getParams();
            ActionMode mode = action.getMode();
            String opts = Utils.join(params.getJvmArgs(), " ").trim();
            String realOpts = Utils.join(ManagementFactory.getRuntimeMXBean().getInputArguments(), " ").trim();
            if (opts.isEmpty()) {
                opts = "<none>";
            }
            if (realOpts.isEmpty()) {
                realOpts = "<none>";
            }
            Version.printVersion(this.out);
            this.out.println("# VM invoker: " + params.getJvm());
            this.out.println("# VM invoker: " + params.getJvm());
            this.out.println("# VM options: " + realOpts + (opts.equals(realOpts) ? "" : " *** WARNING: some JVM options are ignored in non-forked runs ***"));
            this.out.startBenchmark(params);
            this.out.println("");
            this.etaBeforeBenchmark();
            this.out.println("# Fork: N/A, test runs in the existing VM");
            final ArrayList<IterationResult> res = new ArrayList<IterationResult>();
            IterationResultAcceptor acceptor = new IterationResultAcceptor(){

                @Override
                public void accept(IterationResult iterationData) {
                    res.add(iterationData);
                }
            };
            this.doSingle(params, mode, acceptor);
            if (!res.isEmpty()) {
                BenchmarkResult br = new BenchmarkResult(res);
                results.put(params, br);
                this.out.endBenchmark(br);
            }
            this.etaAfterBenchmark(params);
        }
        return results;
    }

    private void doSingle(BenchmarkParams params, ActionMode mode, IterationResultAcceptor acceptor) {
        block6: {
            try {
                switch (mode) {
                    case WARMUP: {
                        this.runBenchmark(params, null);
                        this.out.println("");
                        break;
                    }
                    case WARMUP_MEASUREMENT: 
                    case MEASUREMENT: {
                        this.runBenchmark(params, acceptor);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown mode: " + (Object)((Object)mode));
                    }
                }
            }
            catch (BenchmarkException be) {
                this.out.println("<failure>");
                this.out.println("");
                this.out.println(Utils.throwableToString(be.getCause()));
                this.out.println("");
                if (!this.options.shouldFailOnError().orElse(false).booleanValue()) break block6;
                throw be;
            }
        }
    }

    protected void etaAfterBenchmark(BenchmarkParams params) {
        long current = System.nanoTime();
        this.projectedRunningTime += this.estimateTimeSingleFork(params);
        this.actualRunningTime += current - this.benchmarkStart;
        this.benchmarkStart = current;
    }

    protected void etaBeforeBenchmarks(Collection<ActionPlan> plans) {
        this.projectedTotalTime = 0L;
        for (ActionPlan plan : plans) {
            for (Action act : plan.getActions()) {
                BenchmarkParams params = act.getParams();
                this.projectedTotalTime += (long)(Math.max(1, params.getForks()) + params.getWarmupForks()) * this.estimateTimeSingleFork(params);
            }
        }
    }

    private long estimateTimeSingleFork(BenchmarkParams params) {
        IterationParams wp = params.getWarmup();
        IterationParams mp = params.getMeasurement();
        long estimatedTime = params.getMode() == Mode.SingleShotTime ? (long)(wp.getCount() + mp.getCount()) * TimeUnit.MILLISECONDS.toNanos(1L) : (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.NANOSECONDS) + (long)mp.getCount() * mp.getTime().convertTo(TimeUnit.NANOSECONDS);
        return estimatedTime;
    }

    protected void etaBeforeBenchmark() {
        double partsDone;
        if (this.benchmarkStart == 0L) {
            this.benchmarkStart = System.nanoTime();
        }
        long totalETA = (partsDone = 1.0 * (double)this.projectedRunningTime / (double)this.projectedTotalTime) != 0.0 ? (long)((double)this.actualRunningTime * (1.0 / partsDone - 1.0)) : this.projectedTotalTime;
        this.out.println(String.format("# Run progress: %.2f%% complete, ETA %s", partsDone * 100.0, this.formatDuration(totalETA)));
    }

    protected void etaAfterBenchmarks() {
        this.out.println(String.format("# Run complete. Total time: %s", this.formatDuration(this.actualRunningTime)));
        this.out.println("");
    }

    private String formatDuration(long nanos) {
        long days = TimeUnit.NANOSECONDS.toDays(nanos);
        long hrs = TimeUnit.NANOSECONDS.toHours(nanos -= days * TimeUnit.DAYS.toNanos(1L));
        long mins = TimeUnit.NANOSECONDS.toMinutes(nanos -= hrs * TimeUnit.HOURS.toNanos(1L));
        long secs = TimeUnit.NANOSECONDS.toSeconds(nanos -= mins * TimeUnit.MINUTES.toNanos(1L));
        return String.format("%s%02d:%02d:%02d", days > 0L ? days + " days, " : "", hrs, mins, secs);
    }

    void runBenchmark(BenchmarkParams benchParams, IterationResultAcceptor acceptor) {
        BenchmarkHandler handler = null;
        try {
            String target = benchParams.generatedBenchmark();
            int lastDot = target.lastIndexOf(46);
            Class<?> clazz = ClassUtils.loadClass(target.substring(0, lastDot));
            Method method = BenchmarkHandlers.findBenchmarkMethod(clazz, target.substring(lastDot + 1));
            handler = BenchmarkHandlers.getInstance(this.out, clazz, method, benchParams, this.options);
            this.runBenchmark(benchParams, handler, acceptor);
        }
        catch (BenchmarkException be) {
            throw be;
        }
        catch (Throwable ex) {
            throw new BenchmarkException(ex);
        }
        finally {
            if (handler != null) {
                handler.shutdown();
            }
        }
    }

    protected void runBenchmark(BenchmarkParams benchParams, BenchmarkHandler handler, IterationResultAcceptor acceptor) {
        IterationParams wp = benchParams.getWarmup();
        for (int i = 1; i <= wp.getCount(); ++i) {
            if (this.runSystemGC()) {
                this.out.verbosePrintln("System.gc() executed");
            }
            this.out.iteration(benchParams, wp, i);
            boolean isLastIteration = benchParams.getMeasurement().getCount() == 0;
            IterationResult iterData = handler.runIteration(benchParams, wp, isLastIteration);
            this.out.iterationResult(benchParams, wp, i, iterData);
        }
        IterationParams mp = benchParams.getMeasurement();
        for (int i = 1; i <= mp.getCount(); ++i) {
            if (this.runSystemGC()) {
                this.out.verbosePrintln("System.gc() executed");
            }
            this.out.iteration(benchParams, mp, i);
            boolean isLastIteration = i == mp.getCount();
            IterationResult iterData = handler.runIteration(benchParams, mp, isLastIteration);
            this.out.iterationResult(benchParams, mp, i, iterData);
            if (acceptor == null) continue;
            acceptor.accept(iterData);
        }
    }

    public boolean runSystemGC() {
        if (this.options.shouldDoGC().orElse(false).booleanValue()) {
            ArrayList<GarbageCollectorMXBean> enabledBeans = new ArrayList<GarbageCollectorMXBean>();
            long beforeGcCount = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = bean.getCollectionCount();
                if (count == -1L) continue;
                enabledBeans.add(bean);
            }
            for (GarbageCollectorMXBean bean : enabledBeans) {
                beforeGcCount += bean.getCollectionCount();
            }
            System.gc();
            int MAX_WAIT_MSEC = 20000;
            if (enabledBeans.isEmpty()) {
                this.out.println("WARNING: MXBeans can not report GC info. System.gc() invoked, pessimistically waiting 20000 msecs");
                try {
                    TimeUnit.MILLISECONDS.sleep(20000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            long start = System.nanoTime();
            while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) < 20000L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                long afterGcCount = 0L;
                for (GarbageCollectorMXBean bean : enabledBeans) {
                    afterGcCount += bean.getCollectionCount();
                }
                if (afterGcCount <= beforeGcCount) continue;
                return true;
            }
            this.out.println("WARNING: System.gc() was invoked but couldn't detect a GC occuring, is System.gc() disabled?");
            return false;
        }
        return false;
    }
}

