/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.runner.BaseBenchmarkHandler;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.InfraControl;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.TimeValue;

class LoopBenchmarkHandler
extends BaseBenchmarkHandler {
    private final Method method;

    LoopBenchmarkHandler(OutputFormat format, Class<?> clazz, Method method, Options options, BenchmarkParams executionParams) {
        super(format, clazz, options, executionParams);
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IterationResult runIteration(BenchmarkParams benchmarkParams, IterationParams params, boolean last) {
        int numThreads = benchmarkParams.getThreads();
        TimeValue runtime = params.getTime();
        CountDownLatch preSetupBarrier = new CountDownLatch(numThreads);
        CountDownLatch preTearDownBarrier = new CountDownLatch(numThreads);
        IterationResult iterationResults = new IterationResult(benchmarkParams, params);
        InfraControl control = new InfraControl(benchmarkParams, params, preSetupBarrier, preTearDownBarrier, last);
        BenchmarkTask[] runners = new BenchmarkTask[numThreads];
        ThreadParams[] threadParamses = LoopBenchmarkHandler.distributeThreads(numThreads, benchmarkParams.getThreadGroups());
        for (int i = 0; i < runners.length; ++i) {
            runners[i] = new BenchmarkTask(control, threadParamses[i]);
        }
        long waitDeadline = System.nanoTime() + benchmarkParams.getTimeout().convertTo(TimeUnit.NANOSECONDS);
        this.startProfilers(benchmarkParams, params);
        HashMap<BenchmarkTask, Future<Collection<? extends Result>>> results = new HashMap<BenchmarkTask, Future<Collection<? extends Result>>>();
        for (BenchmarkTask runner : runners) {
            results.put(runner, this.executor.submit(runner));
        }
        control.awaitWarmupReady();
        switch (benchmarkParams.getMode()) {
            case SingleShotTime: {
                break;
            }
            default: {
                try {
                    runtime.sleep();
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        control.isDone = true;
        control.awaitWarmdownReady();
        try {
            int expected = numThreads;
            while (expected > 0) {
                for (Map.Entry re : results.entrySet()) {
                    BenchmarkTask task = (BenchmarkTask)re.getKey();
                    Future fr = (Future)re.getValue();
                    try {
                        long waitFor = Math.max(TimeUnit.MILLISECONDS.toNanos(100L), waitDeadline - System.nanoTime());
                        fr.get(waitFor, TimeUnit.NANOSECONDS);
                        --expected;
                    }
                    catch (InterruptedException ex) {
                        throw new BenchmarkException(ex);
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause().getCause().getCause();
                        throw new BenchmarkException(cause);
                    }
                    catch (TimeoutException e) {
                        Thread runner = task.runner;
                        if (runner == null) continue;
                        this.out.print("(*interrupt*) ");
                        runner.interrupt();
                    }
                }
            }
        }
        finally {
            this.stopProfilers(benchmarkParams, params, iterationResults);
        }
        for (Future fr : results.values()) {
            try {
                iterationResults.addResults((Collection)fr.get());
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException("Impossible to be here");
            }
            catch (ExecutionException ex) {
                throw new IllegalStateException("Impossible to be here");
            }
        }
        return iterationResults;
    }

    class BenchmarkTask
    implements Callable<Collection<? extends Result>> {
        private volatile Thread runner;
        private final InfraControl control;
        private final ThreadParams threadParams;

        BenchmarkTask(InfraControl control, ThreadParams threadParams) {
            this.control = control;
            this.threadParams = threadParams;
        }

        @Override
        public Collection<? extends Result> call() throws Exception {
            try {
                this.runner = Thread.currentThread();
                Collection collection = (Collection)LoopBenchmarkHandler.this.method.invoke(LoopBenchmarkHandler.this.instances.get(), this.control, this.threadParams);
                return collection;
            }
            catch (Throwable e) {
                this.control.preSetupForce();
                this.control.preTearDownForce();
                if (this.control.benchmarkParams.shouldSynchIterations()) {
                    try {
                        this.control.announceWarmupReady();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    try {
                        this.control.announceWarmdownReady();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new Exception(e);
            }
            finally {
                this.runner = null;
            }
        }
    }
}

