/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.format;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormatFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.runner.format.AbstractOutputFormat;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;

class TextReportFormat
extends AbstractOutputFormat {
    public TextReportFormat(PrintStream out, VerboseMode verbose) {
        super(out, verbose);
    }

    @Override
    public void startBenchmark(BenchmarkParams params) {
        IterationParams warmup = params.getWarmup();
        if (warmup.getCount() > 0) {
            this.out.println("# Warmup: " + warmup.getCount() + " iterations, " + warmup.getTime() + " each" + (warmup.getBatchSize() <= 1 ? "" : ", " + warmup.getBatchSize() + " calls per op"));
        } else {
            this.out.println("# Warmup: <none>");
        }
        IterationParams measurement = params.getMeasurement();
        if (measurement.getCount() > 0) {
            this.out.println("# Measurement: " + measurement.getCount() + " iterations, " + measurement.getTime() + " each" + (measurement.getBatchSize() <= 1 ? "" : ", " + measurement.getBatchSize() + " calls per op"));
        } else {
            this.out.println("# Measurement: <none>");
        }
        TimeValue timeout = params.getTimeout();
        boolean timeoutWarning = timeout.convertTo(TimeUnit.NANOSECONDS) <= measurement.getTime().convertTo(TimeUnit.NANOSECONDS) || timeout.convertTo(TimeUnit.NANOSECONDS) <= warmup.getTime().convertTo(TimeUnit.NANOSECONDS);
        this.out.println("# Timeout: " + timeout + " per iteration" + (timeoutWarning ? ", ***WARNING: The timeout might be too low!***" : ""));
        this.out.println("# Threads: " + params.getThreads() + " " + TextReportFormat.getThreadsString(params.getThreads()) + (params.shouldSynchIterations() ? ", will synchronize iterations" : (params.getMode() == Mode.SingleShotTime ? "" : ", ***WARNING: Synchronize iterations are disabled!***")));
        this.out.println("# Benchmark mode: " + params.getMode().longLabel());
        this.out.println("# Benchmark: " + params.getBenchmark());
        if (!params.getParamsKeys().isEmpty()) {
            String s = "";
            boolean isFirst = true;
            for (String k : params.getParamsKeys()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    s = s + ", ";
                }
                s = s + k + " = " + params.getParam(k);
            }
            this.out.println("# Parameters: (" + s + ")");
        }
    }

    @Override
    public void iteration(BenchmarkParams benchmarkParams, IterationParams params, int iteration) {
        switch (params.getType()) {
            case WARMUP: {
                this.out.print(String.format("# Warmup Iteration %3d: ", iteration));
                break;
            }
            case MEASUREMENT: {
                this.out.print(String.format("Iteration %3d: ", iteration));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown iteration type: " + (Object)((Object)params.getType()));
            }
        }
        this.out.flush();
    }

    protected static String getThreadsString(int t) {
        if (t > 1) {
            return "threads";
        }
        return "thread";
    }

    @Override
    public void iterationResult(BenchmarkParams benchmParams, IterationParams params, int iteration, IterationResult data) {
        StringBuilder sb = new StringBuilder();
        sb.append(data.getPrimaryResult().toString());
        if (params.getType() == IterationType.MEASUREMENT) {
            int prefixLen = String.format("Iteration %3d: ", iteration).length();
            Map<String, Result> secondary = data.getSecondaryResults();
            if (!secondary.isEmpty()) {
                sb.append("\n");
                int maxKeyLen = 0;
                for (Map.Entry<String, Result> res : secondary.entrySet()) {
                    maxKeyLen = Math.max(maxKeyLen, res.getKey().length());
                }
                for (Map.Entry<String, Result> res : secondary.entrySet()) {
                    sb.append(String.format("%" + prefixLen + "s", ""));
                    sb.append(String.format("  %-" + (maxKeyLen + 1) + "s %s", res.getKey() + ":", res.getValue()));
                    sb.append("\n");
                }
            }
        }
        this.out.print(String.format("%s%n", sb.toString()));
        this.out.flush();
    }

    @Override
    public void endBenchmark(BenchmarkResult result) {
        this.out.println();
        if (result != null) {
            this.out.println(result.getPrimaryResult().extendedInfo(null));
            for (Result r : result.getSecondaryResults().values()) {
                this.out.println(r.extendedInfo(r.getLabel()));
            }
            this.out.println();
        }
    }

    @Override
    public void startRun() {
    }

    @Override
    public void endRun(Collection<RunResult> runResults) {
        ResultFormatFactory.getInstance(ResultFormatType.TEXT, this.out).writeOut(runResults);
    }
}

