/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.inference.TestUtils;
import org.openjdk.jmh.util.Statistics;

public abstract class AbstractStatistics
implements Statistics {
    private static final long serialVersionUID = 1536835581997509117L;

    @Override
    public double[] getConfidenceIntervalAt(double confidence) {
        double[] interval = new double[2];
        if (this.getN() <= 2L) {
            interval[1] = Double.NaN;
            interval[0] = Double.NaN;
            return interval;
        }
        TDistribution tDist = new TDistribution(this.getN() - 1L);
        double a = tDist.inverseCumulativeProbability(1.0 - (1.0 - confidence) / 2.0);
        interval[0] = this.getMean() - a * this.getStandardDeviation() / Math.sqrt(this.getN());
        interval[1] = this.getMean() + a * this.getStandardDeviation() / Math.sqrt(this.getN());
        return interval;
    }

    @Override
    public boolean isDifferent(Statistics other, double confidence) {
        return TestUtils.tTest(this, (StatisticalSummary)other, 1.0 - confidence);
    }

    @Override
    public double getMeanErrorAt(double confidence) {
        if (this.getN() <= 2L) {
            return Double.NaN;
        }
        TDistribution tDist = new TDistribution(this.getN() - 1L);
        double a = tDist.inverseCumulativeProbability(1.0 - (1.0 - confidence) / 2.0);
        return a * this.getStandardDeviation() / Math.sqrt(this.getN());
    }

    public String toString() {
        return "N:" + this.getN() + " Mean: " + this.getMean() + " Min: " + this.getMin() + " Max: " + this.getMax() + " StdDev: " + this.getStandardDeviation();
    }

    @Override
    public double getMean() {
        if (this.getN() > 0L) {
            return this.getSum() / (double)this.getN();
        }
        return Double.NaN;
    }

    @Override
    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public int compareTo(Statistics other, double confidence) {
        if (this.isDifferent(other, confidence)) {
            double o;
            double t = this.getMean();
            return t > (o = other.getMean()) ? -1 : 1;
        }
        return 0;
    }

    @Override
    public int compareTo(Statistics other) {
        return this.compareTo(other, 0.99);
    }
}

