/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.openjdk.jmh.util.Multiset;

public class Multisets {
    public static <T> Collection<T> countHighest(Multiset<T> set, int top) {
        PriorityQueue q = new PriorityQueue(10, new Comparator<Pair<T, Long>>(){

            @Override
            public int compare(Pair<T, Long> o1, Pair<T, Long> o2) {
                return ((Long)o2.k2).compareTo((Long)o1.k2);
            }
        });
        for (T key : set.keys()) {
            q.add(new Pair(key, set.count(key)));
        }
        ArrayList result = new ArrayList();
        for (int t = 0; t < top && !q.isEmpty(); ++t) {
            result.add(((Pair)q.poll()).k1);
        }
        return result;
    }

    public static <T> List<T> sortedDesc(final Multiset<T> set) {
        ArrayList<T> sorted = new ArrayList<T>();
        sorted.addAll(set.keys());
        Collections.sort(sorted, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Long.valueOf(set.count(o2)).compareTo(set.count(o1));
            }
        });
        return sorted;
    }

    private static class Pair<K1, K2> {
        public final K1 k1;
        public final K2 k2;

        private Pair(K1 k1, K2 k2) {
            this.k1 = k1;
            this.k2 = k2;
        }
    }
}

