/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.util.FileUtils;

public class Version {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printVersion(OutputFormat pw) {
        Properties p = new Properties();
        InputStream s = Version.class.getResourceAsStream("/jmh.properties");
        if (s == null) {
            pw.println("# Cannot figure out JMH version, no jmh.properties");
            return;
        }
        try {
            p.load(s);
        }
        catch (IOException e) {
            pw.println("# Cannot figure out JMH version");
            return;
        }
        finally {
            FileUtils.safelyClose(s);
        }
        String version = (String)p.get("jmh.version");
        if (version == null) {
            pw.println("# Cannot read jmh.version");
            return;
        }
        pw.print("# JMH " + version + " ");
        String time = (String)p.get("jmh.buildDate");
        if (time == null) {
            pw.println("(cannot read jmh.buildDate)");
            return;
        }
        pw.print("(released ");
        try {
            Date parse = new SimpleDateFormat("yyyy/MM/dd", Locale.ROOT).parse(time);
            long diff = (System.currentTimeMillis() - parse.getTime()) / TimeUnit.DAYS.toMillis(1L);
            if (diff > 0L) {
                pw.print(String.format("%d days ago", diff));
                if (diff > 30L) {
                    pw.print(", please consider updating!");
                }
            } else {
                pw.print("today");
            }
        }
        catch (ParseException e) {
            pw.print(time);
        }
        pw.println(")");
    }
}

